<?php

/**
 * Routes configuration.
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * It's loaded within the context of `Application::routes()` method which
 * receives a `RouteBuilder` instance `$routes` as method argument.
 *
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 */

use Cake\Routing\Route\DashedRoute;

use Cake\Routing\RouteBuilder;

return static function (RouteBuilder $routes) {
	/*
     * The default class to use for all routes
     *
     * The following route classes are supplied with CakePHP and are appropriate
     * to set as the default:
     *
     * - Route
     * - InflectedRoute
     * - DashedRoute
     *
     * If no call is made to `Router::defaultRouteClass()`, the class used is
     * `Route` (`Cake\Routing\Route\Route`)
     *
     * Note that `Route` does not do any inflections on URLs which will result in
     * inconsistently cased URLs when used with `{plugin}`, `{controller}` and
     * `{action}` markers.
     */
	$routes->setRouteClass(DashedRoute::class);

	$routes->scope('/', function (RouteBuilder $builder) {

		/*
         * Here, we are connecting '/' (base path) to a controller called 'Pages',
         * its action called 'display', and we pass a param to select the view file
         * to use (in this case, templates/Pages/home.php)...
         */
		//$builder->connect('/', ['controller' => 'pages', 'action' => 'login', 'home']);
		$builder->redirect(
			'/',
			['controller' => 'users', 'action' => 'logout'],
			['persist' => false, 'prefix' => 'admin']
			// Or ['persist'=>['id']] for default routing where the
			// view action expects $id as an argument.
		);

		/*
         * ...and connect the rest of 'Pages' controller's URLs.
         */
		//   $builder->connect('/articles/*', ['controller' => 'Articles', 'action' => 'view']);

		/*
         * Connect catchall routes for all controllers.
         *
         * The `fallbacks` method is a shortcut for
         *
         * ```
         * $builder->connect('/{controller}', ['action' => 'index']);
         * $builder->connect('/{controller}/{action}/*', []);
         * ```
         *
         * You can remove these routes once you've connected the
         * routes you want in your application.
         */
		$builder->fallbacks();
	});

	$routes->prefix('Admin', ['_namePrefix' => 'admin:'], function (RouteBuilder $routes) {
		//$routes->connect('/{controller}/{action}');

		$routes->connect('/categories/add', ['controller' => 'categories', 'action' => 'add']);
		$routes->connect('/categories/show-product-categories', ['controller' => 'categories', 'action' => 'index']);

		$routes->connect('/products/show-all-products', ['controller' => 'products', 'action' => 'index']);
		$routes->connect('/sales/sales-management', ['controller' => 'sales', 'action' => 'index']);
		$routes->connect('/stocks/stocks-management', ['controller' => 'stocks', 'action' => 'index']);
		$routes->connect('/transactions/system-overview', ['controller' => 'transactions', 'action' => 'dashboard']);
		$routes->connect('/transactions/point-of-sale', ['controller' => 'transactions', 'action' => 'beginpos']);
		$routes->connect('/transactions/purchase-transactions', ['controller' => 'transactions', 'action' => 'purchasetransactions']);
		$routes->connect('/transactions/stocks-transactions', ['controller' => 'transactions', 'action' => 'stockstransactions']);

		$routes->connect('/sales/show-sales-report', ['controller' => 'sales', 'action' => 'salesreport']);
		$routes->connect('/stocks/show-stocks-report', ['controller' => 'stocks', 'action' => 'stocksreport']);
		$routes->connect('/products/show-products-report', ['controller' => 'products', 'action' => 'productreport']);
		$routes->connect('/users/show-users-report', ['controller' => 'users', 'action' => 'userreport']);
		$routes->connect('/users/show-attendance-report', ['controller' => 'users', 'action' => 'attendancereport']);
		$routes->connect('/settings/site-settings', ['controller' => 'settings', 'action' => 'edit', 1]);
		$routes->connect('/users/my-profile', ['controller' => 'users', 'action' => 'myprofile']);
		$routes->connect('/users/change-password', ['controller' => 'users', 'action' => 'changepassword']);

		/*---------------
		Members Routes
		---------------*/
		$routes->connect('/members/show-members-list', ['controller' => 'members', 'action' => 'index']);
		$routes->connect('/members/monthly-reports', ['controller' => 'members', 'action' => 'reports']);
		$routes->connect('/members/members-resumption', ['controller' => 'members', 'action' => 'resumption']);
		$routes->connect('/members/document-viewer', ['controller' => 'members', 'action' => 'documents']);
		$routes->connect('/members/certificate-printing', ['controller' => 'members', 'action' => 'certificate']);
		$routes->connect('/members/members-prooflist', ['controller' => 'members', 'action' => 'prooflist']);
		$routes->connect('/members/members-broadcast', ['controller' => 'members', 'action' => 'broadcast']);
		$routes->connect('/members/group-resumptions', ['controller' => 'members', 'action' => 'groupresumptions']);
		$routes->connect('/members/memberes-special-module', ['controller' => 'members', 'action' => 'index']);
		$routes->connect('/members/register-new-account', ['controller' => 'members', 'action' => 'add']);
		$routes->connect('/members/tag-the-member', ['controller' => 'members', 'action' => 'tagmember']);
		$routes->connect('/members/member-registration', ['controller' => 'members', 'action' => 'changeinfo'])
			->setPass(['type', 'refid', 'id'])
			->setPatterns([
				'type' => '[1-4]+',
				'id' => '[0-9]+',
			]);

		/*---------------
		Loans Routes
		---------------*/
		$routes->connect('/loans/index', ['controller' => 'loans', 'action' => 'index']);
		$routes->connect('/loans/add', ['controller' => 'loans', 'action' => 'add']);
		$routes->connect('/loans/memberinfo', ['controller' => 'loans', 'action' => 'memberinfo']);
		$routes->connect('/loans/gettermrates', ['controller' => 'loans', 'action' => 'gettermrates']);
		$routes->connect('/loans/submit', ['controller' => 'loans', 'action' => 'submit']);
		$routes->connect('/loans/view{id}', ['controller' => 'loans', 'action' => 'view'])
			->setPass(['id'])
			->setPatterns(['id' => '[0-9]+']);;

		$routes->connect('/loans/edit', ['controller' => 'loans', 'action' => 'edit'])
			->setPass(['id'])
			->setPatterns(['id' => '[0-9]+']);;

		$routes->connect('/loanstypes/index', ['controller' => 'loanstypes', 'action' => 'index']);
		$routes->connect('/loanstypes/add', ['controller' => 'loanstypes', 'action' => 'add']);
		$routes->connect('/loanstypes/edit/{id}', ['controller' => 'loanstypes', 'action' => 'edit'])
			->setPass(['id'])
			->setPatterns(['id' => '[0-9]+']);
		$routes->connect('/loanstypes/view/{id}', ['controller' => 'loanstypes', 'action' => 'view'])
			->setPass(['id'])
			->setPatterns(['id' => '[0-9]+']);

		$routes->connect('/loansrates/index', ['controller' => 'loansrates', 'action' => 'index']);
		$routes->connect('/loansrates/add', ['controller' => 'loansrates', 'action' => 'add']);
		$routes->connect('/loansrates/edit/{id}', ['controller' => 'loansrates', 'action' => 'edit'])
			->setPass(['id'])
			->setPatterns(['id' => '[0-9]+']);
		$routes->connect('/loansrates/view/{id}', ['controller' => 'loansrates', 'action' => 'view'])
			->setPass(['id'])
			->setPatterns(['id' => '[0-9]+']);

		$routes->connect('/departments/index', ['controller' => 'departments', 'action' => 'index']);
		$routes->connect('/departments/add', ['controller' => 'departments', 'action' => 'add']);
		$routes->connect('/departments/edit', ['controller' => 'departments', 'action' => 'edit']);
		$routes->connect('/departments/delete', ['controller' => 'departments', 'action' => 'delete']);

		$routes->connect('/settings/system-statistics', ['controller' => 'settings', 'action' => 'dashboard']);

		/*---------------
		User Routes
		---------------*/

		$routes->connect('/users/create-new-user', ['controller' => 'users', 'action' => 'add']);
		$routes->connect('/users/upload-users', ['controller' => 'users', 'action' => 'upload']);
		//$routes->connect('/users/show-all-members', ['controller' => 'users', 'action' => 'index']);

		$routes->connect(
			'/users/show-all-members',
			['controller' => 'users', 'action' => 'index']
		);


		$routes->connect('/users/users-masterlist-report', ['controller' => 'users', 'action' => 'index']);
		$routes->connect('/users/view-user-profile/{refid}-{id}', ['controller' => 'users', 'action' => 'view'])
			->setPass(['id', 'refid'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/users/update-user/{refid}-{id}-{type}', ['controller' => 'users', 'action' => 'edit'])
			->setPass(['id', 'refid', 'type'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/users/avatar/{refid}-{id}', ['controller' => 'users', 'action' => 'avatar'])
			->setPass(['id', 'refid'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect(
			'/users/download/{role_id}-{status}-{download_type}',
			['controller' => 'users', 'action' => 'download']
		)
			->setPass(['role_id', 'status', 'download_type'])
			->setPatterns([
				'role_id' => '[0-9]+',
			]);

		$routes->connect(
			'/users/resetaccount/{refid}-{user_id}-{reset_type}',
			['controller' => 'users', 'action' => 'resetaccount']
		)
			->setPass(['refid', 'user_id', 'reset_type'])
			->setPatterns([
				'user_id' => '[0-9]+',
			]);

		$routes->connect(
			'/users/generatecode/{step}-{type}',
			['controller' => 'users', 'action' => 'generatecode']
		)
			->setPass(['step', 'type']);

		/*----------------
		Position Routes
		----------------*/
		$routes->connect('/officerpositions/position-masterlist', ['controller' => 'officerpositions', 'action' => 'index']);

		$routes->connect('/officerpositions/show-positions/{name}-{id}', ['controller' => 'officerpositions', 'action' => 'index'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/officerpositions/create-new-position', ['controller' => 'officerpositions', 'action' => 'add']);
		$routes->connect(
			'/officerpositions/update-position/{id}-{name}',
			['controller' => 'officerpositions', 'action' => 'edit']
		)
			->setPass(['id', 'name'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect(
			'/officerpositions/save-changes/{id}-{name}',
			['controller' => 'officerpositions', 'action' => 'saveedit']
		)
			->setPass(['id', 'name'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect(
			'/officerpositions/getList/{id}',
			['controller' => 'officerpositions', 'action' => 'getList']
		)
			->setPass(['id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		/* 	$routes->connect(
			'/officerpositions/generate-results/{election_id}-{position_id}',
			['controller' => 'officerpositions', 'action' => 'tagwinner']
		)
		->setPass(['election_id', 'position_id']); */

		/*----------------
		Candidates Routes
		----------------*/
		$routes->connect('/candidates/show-all-candidates', ['controller' => 'candidates', 'action' => 'index']);
		$routes->connect('/candidates/candidates-masterlist-report', ['controller' => 'candidates', 'action' => 'index']);
		$routes->connect('/candidates/register-new-candidate', ['controller' => 'candidates', 'action' => 'selectelection']);
		$routes->connect('/candidates/create/{name}-{id}', ['controller' => 'candidates', 'action' => 'add'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/candidates/register-candidate/{name}-{id}-{position}', ['controller' => 'candidates', 'action' => 'add'])
			->setPass(['name', 'id', 'position'])
			->setPatterns([
				'id' => '[0-9]+',
				'position' => '[0-9]+'
			]);

		$routes->connect(
			'/candidates/candidate-details/{refid}-{id}',
			['controller' => 'candidates', 'action' => 'view']
		)
			->setPass(['refid', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
				'position' => '[0-9]+'
			]);

		$routes->connect(
			'/candidates/update-candidate/{refid}-{id}',
			['controller' => 'candidates', 'action' => 'edit']
		)
			->setPass(['refid', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
				'position' => '[0-9]+'
			]);

		$routes->connect(
			'/candidates/save-changes/{refid}-{id}',
			['controller' => 'candidates', 'action' => 'saveedit']
		)
			->setPass(['refid', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
				'position' => '[0-9]+'
			]);

		$routes->connect(
			'/candidates/download/{election_id}-{position_id}-{download_type}',
			['controller' => 'candidates', 'action' => 'download']
		)
			->setPass(['election_id', 'position_id', 'download_type']);


		/*----------------
		Election Routes
		----------------*/
		$routes->connect('/elections/current-elections', ['controller' => 'elections', 'action' => 'status']);
		$routes->connect('/elections/election-dashboard', ['controller' => 'elections', 'action' => 'status']);
		$routes->connect('/elections/election-masterlist', ['controller' => 'elections', 'action' => 'index']);
		$routes->connect('/elections/create-new-election', ['controller' => 'elections', 'action' => 'add']);
		$routes->connect('/elections/election-details/{name}-{id}', ['controller' => 'elections', 'action' => 'view'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/elections/update-election/{name}-{id}', ['controller' => 'elections', 'action' => 'edit'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/elections/save-election-changes/{name}-{id}', ['controller' => 'elections', 'action' => 'saveedit'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect(
			'/elections/election-result-report',
			['controller' => 'elections', 'action' => 'report']
		);

		$routes->connect(
			'/elections/download/{election_id}-{download_type}',
			['controller' => 'elections', 'action' => 'download']
		)
			->setPass(['election_id', 'download_type'])
			->setPatterns([
				'election_id' => '[0-9]+',
			]);

		/*----------------
		UAM Masterlist
		----------------*/
		$routes->connect('/uams/uam-masterlist', ['controller' => 'uams', 'action' => 'index']);
		$routes->connect('/uams/create-new-access-matrix', ['controller' => 'uams', 'action' => 'add']);
		$routes->connect('/pages/download-members-upload-file/', ['controller' => 'pages', 'action' => 'download', 'members_upload.xlsx']);

		$routes->fallbacks(DashedRoute::class);


		/*----------------
		Vote Counts
		----------------*/
		$routes->connect(
			'/votecounts/election-participation-report',
			['controller' => 'votecounts', 'action' => 'report']
		);

		$routes->connect(
			'/votecounts/download/{election_id}-{download_type}',
			['controller' => 'votecounts', 'action' => 'download']
		)
			->setPass(['election_id', 'download_type'])
			->setPatterns([
				'election_id' => '[0-9]+',
			]);
	});

	$routes->prefix('Member', ['_namePrefix' => 'member:'], function (RouteBuilder $routes) {

		$routes->connect('/{controller}/{action}');

		$routes->connect('/categories/add', ['controller' => 'categories', 'action' => 'add']);
		$routes->connect('/categories/show-product-categories', ['controller' => 'categories', 'action' => 'index']);

		$routes->connect('/products/show-all-products', ['controller' => 'products', 'action' => 'index']);
		$routes->connect('/sales/sales-management', ['controller' => 'sales', 'action' => 'index']);
		$routes->connect('/stocks/stocks-management', ['controller' => 'stocks', 'action' => 'index']);
		$routes->connect('/transactions/system-overview', ['controller' => 'transactions', 'action' => 'dashboard']);
		$routes->connect('/transactions/point-of-sale', ['controller' => 'transactions', 'action' => 'beginpos']);
		$routes->connect('/transactions/purchase-transactions', ['controller' => 'transactions', 'action' => 'purchasetransactions']);
		$routes->connect('/transactions/stocks-transactions', ['controller' => 'transactions', 'action' => 'stockstransactions']);

		$routes->connect('/sales/show-sales-report', ['controller' => 'sales', 'action' => 'salesreport']);
		$routes->connect('/stocks/show-stocks-report', ['controller' => 'stocks', 'action' => 'stocksreport']);
		$routes->connect('/products/show-products-report', ['controller' => 'products', 'action' => 'productreport']);
		$routes->connect('/users/show-users-report', ['controller' => 'users', 'action' => 'userreport']);
		$routes->connect('/users/show-attendance-report', ['controller' => 'users', 'action' => 'attendancereport']);
		$routes->connect('/settings/site-settings', ['controller' => 'settings', 'action' => 'index']);
		$routes->connect('/users/my-profile', ['controller' => 'users', 'action' => 'myprofile']);
		$routes->connect('/users/change-password', ['controller' => 'users', 'action' => 'changepassword']);

		/*---------------
		User Routes
		---------------*/
		$routes->connect('/users/my-profile', ['controller' => 'users', 'action' => 'view']);


		/*---------------
		Election Routes
		---------------*/
		$routes->connect(
			'/elections/index',
			['controller' => 'elections', 'action' => 'index']
		);

		$routes->connect(
			'/elections/userelectionlogs/{id}',
			['controller' => 'elections', 'action' => 'userelectionlogs']
		)
			->setPass(['id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		/* $routes->connect('/elections/castvote/{name}-{id}',[ 'controller' => 'elections', 'action' => 'castvote'])
		->setPass(['name', 'id'])
		->setPatterns([
			'id' => '[0-9]+',
		]); */

		$routes->connect(
			'/elections/castvote/{name}-{id}',
			['controller' => 'elections', 'action' => 'castvote']
		)
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);


		$routes->connect('/votecastings/castvote/{name}-{id}', ['controller' => 'votecastings', 'action' => 'castvote'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		$routes->connect('/votecastings/checkvote/{name}-{id}', ['controller' => 'votecastings', 'action' => 'checkvote'])
			->setPass(['name', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);

		/*------------------
		user routes
		------------------*/
		$routes->connect(
			'/users/avatar/{refid}-{id}',
			['controller' => 'users', 'action' => 'avatar']
		)
			->setPass(['refid', 'id'])
			->setPatterns([
				'id' => '[0-9]+',
			]);
	});



	$routes->connect(
		'/articles/{id}-{slug}', // For example, /blog/3-CakePHP_Rocks
		['controller' => 'Articles', 'action' => 'view']
	)
		// Define the route elements in the route template
		// to prepend as function arguments. Order matters as this
		// will pass the `$id` and `$slug` elements as the first and
		// second parameters. Any additional passed parameters in your
		// route will be added after the setPass() arguments.
		->setPass(['id', 'slug'])
		// Define a pattern that `id` must match.
		->setPatterns([
			'id' => '[0-9]+',
		]);

	/*
     * If you need a different set of middleware or none at all,
     * open new scope and define routes there.
     *
     * ```
     * $routes->scope('/api', function (RouteBuilder $builder) {
     *     // No $builder->applyMiddleware() here.
     *
     *     // Parse specified extensions from URLs
     *     // $builder->setExtensions(['json', 'xml']);
     *
     *     // Connect API actions here.
     * });
     * ```
     */
};
